varying vec2 p_textureCoord;
varying vec4 p_color;

uniform sampler2D base_texture;
uniform float bright_pass_threshold;
const  vec3 luminanceVector = vec3(0.2125, 0.7154, 0.0721);

void main()
{
    vec4 sampleColor = texture2D(base_texture, p_textureCoord);

    float luminance = dot(luminanceVector, sampleColor.rgb);
    luminance = max(0.0, luminance - bright_pass_threshold);
    sampleColor.rgb *= sign(luminance);
    sampleColor.a = luminance;
    
    gl_FragColor = sampleColor * p_color;
}
